<?php
/* --------------------------------------------------------------
   UserConfigurationNotFoundException.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Exceptions;

use Exception;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;
use Gambio\Admin\UserConfiguration\Interfaces\UserId;

/**
 * Class UserConfigurationNotFoundException
 *
 * @package Gambio\Admin\UserConfiguration\Exceptions
 * @codeCoverageIgnore
 */
class UserConfigurationNotFoundException extends Exception
{
    /**
     * @param UserId               $userId
     * @param UserConfigurationKey $key
     *
     * @return UserConfigurationNotFoundException
     */
    public static function create(
        UserId $userId,
        UserConfigurationKey $key
    ): UserConfigurationNotFoundException {
        return new self('No user configuration found for user "' . $userId->userId() . '" and key "' . $key->value()
                        . '".');
    }
}